#!/bin/bash

ARGS="$@"

usage() {

cat  <<EOF
Usage: 
$0 "ARGS"
where:
      "ARGS": arguments to pass to Arion (multi-word arguments must be enclosed in double quotes)
EOF
exit

}

if [[ "$0" != \/* ]]; then
    echo Call to this script must be an absolute path
    usage
fi

minargs=1
if [ $# -lt $minargs ]; then
    usage
fi


basedir=$(dirname "$0")

exe="$basedir/arion2.6_impi2021"

source "$basedir/arion_setup.sh" "$basedir" >/dev/null

source /opt/intel/oneapi/compiler/2022.2.1/env/vars.sh 
source /opt/intel/oneapi/mpi/2021.16/env/vars.sh

export OPENBLAS_NUM_THREADS=1

exec "$exe" $ARGS

